import { pickupInformationSchemaExtended } from "@/services/otp/validations/+extended";
import { ItinerarySchema, LegSchema, PlanResponse } from "@/services/otp/validations/planner.graphql";
import { z } from "zod";

export interface ItineraryCategories {
    /**
     * List of all itineraries exteded by middleware.
     */
    all: AppItinerary[],

    /**
     * List of valid itineraries based on the searchWindow
     * and potential filters.
     */
    valid: ItinerarySchema[],

    /**
     * List of filtered itineraries removed while running
     * planner middle ware.
     * 
     * __*This list does not include all future itineraries*__
     */
    filtered: ItinerarySchema[],

    /**
     * List of itineraries which did not match the searchWindow
     * when making requests to plans.
     * 
     * To capture more itineraries, extend the searchWindow for the middleware.
     */
    future: ItinerarySchema[],

}

export interface PlanResponseExtended extends PlanResponse {
    extended: {
        itineraries?: ItineraryCategories
    }
}

export interface ItinerarySchemaExtended extends Omit<ItinerarySchema, "legs"> {
    legs?: LegSchemaExtended[]
}

export interface LegSchemaExtended extends LegSchema {
    extended: {
        pickupInformation?: PickupInformationExtended
    }
}

export type PickupInformationExtended = z.infer<typeof pickupInformationSchemaExtended>

export type AppItinerary = ItinerarySchema | ItinerarySchemaExtended

